{========================================================================}
{=                (c) 1995-98 SwiftSoft Ronald Dittrich                 =}
{========================================================================}
{=                          All Rights Reserved                         =}
{========================================================================}
{=  D 01099 Dresden             = Fax.: +49 (0)351-8037944              =}
{=  Loewenstr.7a                = info@swiftsoft.de                     =}
{========================================================================}
{=  Actual versions on http://www.swiftsoft.de/mmtools.html             =}
{========================================================================}
{=  This code is for reference purposes only and may not be copied or   =}
{=  distributed in any format electronic or otherwise except one copy   =}
{=  for backup purposes.                                                =}
{=                                                                      =}
{=  No Delphi Component Kit or Component individually or in a collection=}
{=  subclassed or otherwise from the code in this unit, or associated   =}
{=  .pas, .dfm, .dcu, .asm or .obj files may be sold or distributed     =}
{=  without express permission from SwiftSoft.                          =}
{=                                                                      =}
{=  For more licence informations please refer to the associated        =}
{=  HelpFile.                                                           =}
{========================================================================}
{=  $Date: 06.09.98 - 14:22:24 $                                        =}
{========================================================================}
unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, MMObj, MMUtils,MMSlider, MMWave, MMDSPObj, MMWavIn, MMDesign, ExtCtrls,
  MMRingBf, MMDIBCv, MMLevel, MMConect, MMCstDlg, MMHook;

type
  TForm1 = class(TForm)
    MMDesigner1: TMMDesigner;
    MMWaveIn1: TMMWaveIn;
    MMWaveFile1: TMMWaveFile;
    Panel1: TPanel;
    MMSlider1: TMMSlider;
    MMSlider2: TMMSlider;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    RadioGroup1: TRadioGroup;
    btnRecord: TButton;
    btnStop: TButton;
    Timer1: TTimer;
    Label5: TLabel;
    CheckBox1: TCheckBox;
    MMRingBuffer1: TMMRingBuffer;
    MMConnector1: TMMConnector;
    MMLevel1: TMMLevel;
    btnPrepare: TButton;
    WaveSaveDialog: TMMWaveSaveDialog;
    procedure MMSlider2Change(Sender: TObject);
    procedure MMSlider1Change(Sender: TObject);
    procedure RadioGroup1Click(Sender: TObject);
    procedure btnRecordClick(Sender: TObject);
    procedure btnStopClick(Sender: TObject);
    procedure MMWaveIn1Start(Sender: TObject);
    procedure MMWaveIn1Stop(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure Timer1Timer(Sender: TObject);
    procedure btnPrepareClick(Sender: TObject);
  private
    Started: Boolean;
    StartPos: Longint;
  public
    procedure StartRecording(Suspended: Boolean);
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

{-- TForm1 --------------------------------------------------------------------}
procedure TForm1.MMSlider1Change(Sender: TObject);
begin
   Label4.Caption := IntToStr(MMSlider1.Position);
   MMWaveIn1.BufferSize := MMSlider1.Position;
end;

{-- TForm1 --------------------------------------------------------------------}
procedure TForm1.MMSlider2Change(Sender: TObject);
begin
   Label3.Caption := IntToStr(MMSlider2.Position);
   MMWaveIn1.NumBuffers := MMSlider2.Position;
end;

{-- TForm1 --------------------------------------------------------------------}
procedure TForm1.RadioGroup1Click(Sender: TObject);
begin
   MMWaveIn1.CallBackMode := TMMCBMode(RadioGroup1.ItemIndex);
end;

{-- TForm1 --------------------------------------------------------------------}
procedure TForm1.StartRecording(Suspended: Boolean);
begin
   if not (wisOpen in MMWaveIn1.State) then
   begin
      if (MMWaveFile1.Wave.FileName = '') then
      begin
         if WaveSaveDialog.Execute then
            MMWaveFile1.Wave.FileName := WaveSaveDialog.FileName;
      end;

      if (MMWaveFile1.Wave.FileName <> '') then
      begin
         MMRingBuffer1.NumBuffers := 2*MMWaveIn1.NumBuffers;
         if CheckBox1.Checked then
            MMRingBuffer1.QueueMode := qmWrite
         else
            MMRingBuffer1.QueueMode := qmNone;
         MMWaveIn1.Start;
      end;
   end;
   Started := not Suspended;
   MMWaveFile1.Enabled := Started;
   StartPos := MMWaveIn1.Position;
end;

{-- TForm1 --------------------------------------------------------------------}
procedure TForm1.btnRecordClick(Sender: TObject);
begin
   StartRecording(False);
   btnRecord.Enabled := False;
   btnPrepare.Enabled := False;
end;

{-- TForm1 --------------------------------------------------------------------}
procedure TForm1.btnPrepareClick(Sender: TObject);
begin
   StartRecording(True);
   if (wisOpen in MMWaveIn1.State) then btnPrepare.Enabled := False;
end;

{-- TForm1 --------------------------------------------------------------------}
procedure TForm1.btnStopClick(Sender: TObject);
begin
   Started := False;
   MMWaveIn1.Stop;
end;

{-- TForm1 --------------------------------------------------------------------}
procedure TForm1.MMWaveIn1Start(Sender: TObject);
begin
   Panel1.Enabled := False;
   Timer1.Enabled := True;
   btnStop.Enabled := True;
end;

{-- TForm1 --------------------------------------------------------------------}
procedure TForm1.MMWaveIn1Stop(Sender: TObject);
begin
   Started := False;
   Panel1.Enabled := True;
   Timer1.Enabled := False;
   btnRecord.Enabled := True;
   btnPrepare.Enabled := True;
   btnStop.Enabled := False;
   MMWaveIn1.Close;
end;

{-- TForm1 --------------------------------------------------------------------}
procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
   MMWaveIn1.Close;
end;

{-- TForm1 --------------------------------------------------------------------}
procedure TForm1.Timer1Timer(Sender: TObject);
begin
   if Started then
   begin
      Label5.Caption := TimeToString(MMWaveIn1.Position-StartPos);
   end;
end;

end.
